<?php
include 'config.php';
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Smart Home - Denah Rumah</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .container {
            max-width: 1400px;
            width: 100%;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            overflow: hidden;
        }

        .header {
            background: #2c3e50;
            color: white;
            padding: 20px;
            text-align: center;
        }

        .header h1 {
            font-size: 2em;
            margin-bottom: 5px;
        }

        .floor-plan {
            padding: 40px;
            background: #f0f0f0;
        }

        .house-container {
            background: white;
            border: 3px solid #2c3e50;
            border-radius: 10px;
            padding: 20px;
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            grid-template-rows: repeat(3, 200px);
            gap: 15px;
            max-width: 1200px;
            margin: 0 auto;
        }

        .room {
            background: #f8f9fa;
            border: 2px solid #dee2e6;
            border-radius: 8px;
            padding: 15px;
            position: relative;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .room:hover {
            transform: scale(1.05);
            box-shadow: 0 5px 20px rgba(0,0,0,0.2);
            z-index: 10;
        }

        .room.active {
            background: #fff9e6;
            border-color: #ffd700;
            box-shadow: 0 0 20px rgba(255, 215, 0, 0.5);
        }

        /* Layout Denah Rumah */
        .kamar-tidur {
            grid-column: 1 / 2;
            grid-row: 1 / 2;
            background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
        }

        .dapur {
            grid-column: 2 / 3;
            grid-row: 1 / 2;
            background: linear-gradient(135deg, #fff3e0 0%, #ffe0b2 100%);
        }

        .ruang-tamu {
            grid-column: 3 / 5;
            grid-row: 1 / 3;
            background: linear-gradient(135deg, #f3e5f5 0%, #e1bee7 100%);
        }

        .kamar-mandi {
            grid-column: 1 / 2;
            grid-row: 2 / 3;
            background: linear-gradient(135deg, #e0f7fa 0%, #b2ebf2 100%);
        }

        .ruang-kerja {
            grid-column: 2 / 3;
            grid-row: 2 / 3;
            background: linear-gradient(135deg, #e8f5e9 0%, #c8e6c9 100%);
        }

        .ruang-makan {
            grid-column: 1 / 3;
            grid-row: 3 / 4;
            background: linear-gradient(135deg, #fce4ec 0%, #f8bbd0 100%);
        }

        .teras {
            grid-column: 3 / 5;
            grid-row: 3 / 4;
            background: linear-gradient(135deg, #f1f8e9 0%, #dcedc8 100%);
        }

        .room-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 10px;
        }

        .room-info {
            flex: 1;
        }

        .room-name {
            font-weight: bold;
            font-size: 1.1em;
            color: #2c3e50;
            margin-bottom: 5px;
        }

        .room-area {
            font-size: 0.85em;
            color: #6c757d;
        }

        .lamp-container {
            text-align: center;
            margin-top: auto;
        }

        .lamp-icon {
            font-size: 4em;
            transition: all 0.3s ease;
            display: inline-block;
        }

        .lamp-off {
            filter: grayscale(100%);
            opacity: 0.4;
        }

        .lamp-on {
            animation: glow 1.5s ease-in-out infinite alternate;
        }

        @keyframes glow {
            from {
                text-shadow: 0 0 10px #fff, 0 0 20px #fff, 0 0 30px #ffd700, 0 0 40px #ffd700;
            }
            to {
                text-shadow: 0 0 20px #fff, 0 0 30px #ffd700, 0 0 40px #ffd700, 0 0 50px #ffd700;
            }
        }

        .status-badge {
            display: inline-block;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.85em;
            font-weight: bold;
            margin-top: 10px;
        }

        .status-badge.on {
            background: #28a745;
            color: white;
        }

        .status-badge.off {
            background: #6c757d;
            color: white;
        }

        .lamp-id {
            font-size: 0.75em;
            color: #6c757d;
            margin-top: 5px;
        }

        .last-update {
            text-align: center;
            padding: 20px;
            background: #f8f9fa;
            border-top: 1px solid #dee2e6;
            font-size: 0.9em;
            color: #6c757d;
        }

        .legend {
            display: flex;
            justify-content: center;
            gap: 30px;
            padding: 20px;
            background: #f8f9fa;
            border-top: 1px solid #dee2e6;
        }

        .legend-item {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .legend-icon {
            width: 20px;
            height: 20px;
            border-radius: 50%;
        }

        .legend-on {
            background: #ffd700;
            box-shadow: 0 0 10px rgba(255, 215, 0, 0.5);
        }

        .legend-off {
            background: #6c757d;
        }

        @media (max-width: 1200px) {
            .house-container {
                grid-template-columns: repeat(2, 1fr);
                grid-template-rows: auto;
            }

            .kamar-tidur, .dapur, .ruang-tamu, .kamar-mandi, 
            .ruang-kerja, .ruang-makan, .teras {
                grid-column: auto;
                grid-row: auto;
            }
        }

        @media (max-width: 768px) {
            .house-container {
                grid-template-columns: 1fr;
                grid-template-rows: auto;
            }

            .lamp-icon {
                font-size: 3em;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🏠 Smart Home Control</h1>
            <p>Denah Rumah & Kontrol 7 Lampu</p>
        </div>

        <div class="floor-plan">
            <div class="house-container" id="houseLayout">
                <!-- Ruangan akan diisi oleh JavaScript -->
            </div>
        </div>

        <div class="legend">
            <div class="legend-item">
                <div class="legend-icon legend-on"></div>
                <span>Lampu Hidup</span>
            </div>
            <div class="legend-item">
                <div class="legend-icon legend-off"></div>
                <span>Lampu Mati</span>
            </div>
        </div>

        <div class="last-update" id="lastUpdate">
            Terakhir update: -
        </div>
    </div>

    <script>
        const rooms = [
            { id: 1, name: 'Kamar Tidur', emoji: '🛏️', area: 'Kamar Utama', class: 'kamar-tidur' },
            { id: 2, name: 'Dapur', emoji: '🍳', area: 'Area Masak', class: 'dapur' },
            { id: 3, name: 'Ruang Tamu', emoji: '🛋️', area: 'Area Utama', class: 'ruang-tamu' },
            { id: 4, name: 'Kamar Mandi', emoji: '🚽', area: 'Kamar Mandi Utama', class: 'kamar-mandi' },
            { id: 5, name: 'Ruang Kerja', emoji: '📚', area: 'Area Kerja', class: 'ruang-kerja' },
            { id: 6, name: 'Ruang Makan', emoji: '🍽️', area: 'Area Makan', class: 'ruang-makan' },
            { id: 7, name: 'Teras Depan', emoji: '🌿', area: 'Area Outdoor', class: 'teras' }
        ];

        function updateLampStatus() {
            fetch('get_status.php')
                .then(response => response.json())
                .then(data => {
                    const houseLayout = document.getElementById('houseLayout');
                    houseLayout.innerHTML = '';

                    data.forEach((lamp, index) => {
                        const room = rooms[index];
                        const isOn = lamp.status === 'on';

                        const roomElement = document.createElement('div');
                        roomElement.className = `room ${room.class} ${isOn ? 'active' : ''}`;
                        roomElement.onclick = () => toggleLamp(lamp.id);

                        roomElement.innerHTML = `
                            <div class="room-header">
                                <div class="room-info">
                                    <div class="room-name">${room.emoji} ${room.name}</div>
                                    <div class="room-area">${room.area}</div>
                                </div>
                            </div>
                            <div class="lamp-container">
                                <div class="lamp-icon ${isOn ? 'lamp-on' : 'lamp-off'}">
                                    💡
                                </div>
                                <div class="status-badge ${lamp.status}">
                                    ${isOn ? '● HIDUP' : '○ MATI'}
                                </div>
                                <div class="lamp-id">Lampu #${lamp.id}</div>
                            </div>
                        `;

                        houseLayout.appendChild(roomElement);
                    });

                    document.getElementById('lastUpdate').textContent =
                        `Terakhir update: ${new Date().toLocaleString('id-ID')}`;
                })
                .catch(error => console.error('Error:', error));
        }

        function toggleLamp(lampId) {
            fetch('toggle_lamp.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `lamp_id=${lampId}`
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    updateLampStatus();
                } else {
                    alert('Error: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Terjadi kesalahan saat mengontrol lampu');
            });
        }

        // Update status setiap 2 detik
        updateLampStatus();
        setInterval(updateLampStatus, 2000);
    </script>
</body>
</html>
