<?php
include 'config.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $lamp_id = intval($_POST['lamp_id']);
    
    if ($lamp_id >= 1 && $lamp_id <= 8) {
        // Get current status
        $sql = "SELECT status FROM saklar_status WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $lamp_id);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $new_status = ($row['status'] == 'on') ? 'off' : 'on';
            
            // Update status
            $update_sql = "UPDATE saklar_status SET status = ?, waktu = CURRENT_TIMESTAMP WHERE id = ?";
            $update_stmt = $conn->prepare($update_sql);
            $update_stmt->bind_param("si", $new_status, $lamp_id);
            
            if ($update_stmt->execute()) {
                echo json_encode(['success' => true, 'new_status' => $new_status]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Gagal update database']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Lampu tidak ditemukan']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'ID lampu tidak valid']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Method tidak diizinkan']);
}

$conn->close();
?>
