<?php include 'config.php'; ?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Denah Lampu</title>
<style>
body {
  margin: 0;
  background: #f4f4f4;
  display: flex;
  justify-content: center;
  align-items: center;
  min-height: 100vh;
  font-family: "Segoe UI", sans-serif;
}

.denah {
  display: grid;
  grid-template-columns: 160px 160px 160px 160px;
  grid-template-rows: 160px 160px 160px 160px;
  gap: 10px;
  background: #e0e0e0;
  padding: 15px;
  border-radius: 12px;
  box-shadow: 0 0 15px rgba(0,0,0,0.15);
}

/* Gaya umum ruangan */
.room {
  border-radius: 10px;
  background: #fafafa;
  border: 2px solid #ccc;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  cursor: pointer;
  transition: all 0.3s ease;
}

.room:hover {
  background: #eee;
  transform: scale(1.05);
}

.room.active {
  border-color: #444;
  background: #ddd;
}

/* Ruangan ditata rapi dengan formasi 3-2-2 */
.kamar-tidur { grid-column: 1 / 2; grid-row: 1 / 2; }
.ruang-tamu { grid-column: 2 / 3; grid-row: 1 / 2; }
.dapur { grid-column: 3 / 4; grid-row: 1 / 2; }
.kamar-mandi { grid-column: 1 / 2; grid-row: 2 / 3; }
.ruang-makan { grid-column: 2 / 3; grid-row: 2 / 3; }
.ruang-kerja { grid-column: 1 / 2; grid-row: 3 / 4; }
.garasi { grid-column: 2 / 3; grid-row: 3 / 4; }
.teras { grid-column: 3 / 4; grid-row: 2 / 3; }

.icon {
  font-size: 2.4em;
  transition: all 0.3s ease;
}

.lamp-on {
  color: #444;
  animation: pulse 1s infinite alternate;
}
.lamp-off {
  color: #999;
  opacity: 0.5;
}

.status {
  margin-top: 4px;
  font-weight: 600;
  font-size: 0.85em;
  color: #333;
}

.lamp-id {
  font-size: 0.75em;
  color: #777;
}

.room-name {
  font-size: 0.85em;
  font-weight: bold;
  margin-top: 5px;
  color: #333;
}

@keyframes pulse {
  from { text-shadow: 0 0 6px #888; }
  to { text-shadow: 0 0 14px #555; }
}

@media (max-width: 768px) {
  .denah {
    grid-template-columns: repeat(4, 1fr);
    grid-template-rows: auto;
  }
  .room { height: 130px; }
}
</style>
</head>
<body>
<div class="denah" id="layout"></div>

<script>
const rooms = [
  { id: 1, class: 'kamar-tidur', name: 'Kamar Tidur' },
  { id: 2, class: 'ruang-tamu', name: 'Ruang Tamu' },
  { id: 3, class: 'dapur', name: 'Dapur' },
  { id: 4, class: 'kamar-mandi', name: 'Kamar Mandi' },
  { id: 5, class: 'ruang-makan', name: 'Ruang Makan' },
  { id: 6, class: 'ruang-kerja', name: 'Ruang Kerja' },
  { id: 7, class: 'garasi', name: 'Garasi' },
  { id: 8, class: 'teras', name: 'Teras' }
];

function updateLampStatus() {
  fetch('get_status.php')
    .then(res => res.json())
    .then(data => {
      const layout = document.getElementById('layout');
      layout.innerHTML = '';
      data.forEach((lamp, i) => {
        const room = rooms[i];
        const isOn = lamp.status === 'on';
        const div = document.createElement('div');
        div.className = `room ${room.class} ${isOn ? 'active' : ''}`;
        div.onclick = () => toggleLamp(lamp.id);
        div.innerHTML = `
          <div class="icon ${isOn ? 'lamp-on' : 'lamp-off'}">💡</div>
          <div class="room-name">${room.name}</div>
          <div class="status">${isOn ? 'ON' : 'OFF'}</div>
          <div class="lamp-id">#${lamp.id}</div>
        `;
        layout.appendChild(div);
      });
    })
    .catch(err => console.error(err));
}

function toggleLamp(id) {
  fetch('toggle_lamp.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
    body: `lamp_id=${id}`
  })
  .then(res => res.json())
  .then(d => { if (d.success) updateLampStatus(); });
}

updateLampStatus();
setInterval(updateLampStatus, 2000);
</script>
</body>
</html>
