<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['title', 'date', 'location', 'price', 'image', 'href' => null]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['title', 'date', 'location', 'price', 'image', 'href' => null]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
// Format Indonesian price
$formattedPrice = $price ? 'Rp ' . number_format($price, 0, ',', '.') : 'Harga tidak tersedia';

$formattedDate = $date
? \Carbon\Carbon::parse($date)->locale('id')->translatedFormat('d F Y, H:i')
: 'Tanggal tidak tersedia';

// Safe image URL: use external URL if provided, otherwise use asset (storage path)
$imageUrl = $image
? (filter_var($image, FILTER_VALIDATE_URL)
? $image
: asset('images/events/' . $image))
: asset('images/konser.jpeg');

?>

<a href="<?php echo e($href ?? '#'); ?>" class="block">
    <div class="card bg-base-100 h-96 shadow-sm hover:shadow-md transition-shadow duration-300">
        <div class="h-48 overflow-hidden bg-gray-100 rounded-t-lg flex items-center justify-center">
            <img 
                src="<?php echo e($imageUrl); ?>" 
                alt="<?php echo e($title); ?>" 
                class="max-w-full max-h-full object-contain"
            >
        </div>

        <div class="card-body">
            <h2 class="card-title">
                <?php echo e($title); ?>

            </h2>

            <p class="text-sm text-gray-500">
                <?php echo e($formattedDate); ?>

            </p>

            <p class="text-sm">
                📍 <?php echo e($location); ?>

            </p>

            <p class="font-bold text-lg mt-2">
                <?php echo e($formattedPrice); ?>

            </p>

        </div>
    </div>
</a><?php /**PATH C:\Users\D2I\Desktop\ticketing_app\resources\views/components/user/event-card.blade.php ENDPATH**/ ?>