#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

unsigned char enc_flag[] = { 212, 223, 195, 211, 223, 221, 235, 212, 233, 254, 164, 253, 161, 243, 207, 164, 254, 164, 252, 233, 165, 161, 227, 207, 194, 163, 237 };

void reveal_flag() {
    char flag[32] = {0};
    int len = sizeof(enc_flag) / sizeof(enc_flag[0]);

    for (int i = 0; i < len; i++) {
        flag[i] = enc_flag[i] ^ 0x90;
    }

    printf("Correct input!\nHere is your flag: %s\n", flag);
}

void logo(){
    printf("                _\n");
    printf("              _( }\n");
    printf("    -=   _  <<  \\\n");
    printf("        `.\\__/`/\\\\\n");
    printf("  -=      '--'\\\\  `\n");
    printf("       -=     //\n");
    printf("   jgs        \\)\n");
    printf("let see, how good u are");
}

int validate_input(const char* input) {
    if (strlen(input) != 8) return 0;

    if (input[0] + input[7] != 'C' + 'T') return 0;
    if ((input[3] ^ input[4]) != 0x10) return 0;
    if ((input[1] * input[2]) % 17 != 5) return 0;
    if ((input[5] - input[6]) == 3) return 1;

    return 0;
}

int main() {
    char input[64];
    logo();
    printf("Enter key: ");
    fgets(input, sizeof(input), stdin);
    input[strcspn(input, "\n")] = '\0';

    if (validate_input(input)) {
        reveal_flag();
    } else {
        puts("Wrong input!");
    }

    return 0;
}
