<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'title',
    'date',
    'location',
    'price',
    'image',
    'href' => null,
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'title',
    'date',
    'location',
    'price',
    'image',
    'href' => null,
]); ?>
<?php foreach (array_filter(([
    'title',
    'date',
    'location',
    'price',
    'image',
    'href' => null,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<?php
    // Format Indonesian price
    $formattedPrice = $price
        ? 'Rp ' . number_format($price, 0, ',', '.')
        : 'Harga tidak tersedia';

    // Format Indonesian date
    $formattedDate = $date
        ? \Carbon\Carbon::parse($date)->locale('id')->translatedFormat('d F Y, H:i')
        : 'Tanggal tidak tersedia';

    // Safe image URL: use external URL if provided, otherwise use storage URL
    if ($image && filter_var($image, FILTER_VALIDATE_URL)) {
        $imageUrl = $image;
    } else {
        // Use provided image if it exists and file is found, otherwise use default
        $imageName = (!empty($image) && file_exists(public_path('storage/' . $image))) ? $image : 'konser.jpg';
        $imageUrl = asset('storage/' . $imageName);
    }
?>

<a href="<?php echo e($href ?? '#'); ?>" class="block">
  <div class="card bg-base-100 h-96 shadow-sm hover:shadow-md transition-shadow duration-300">
      <figure>
          <img src="<?php echo e($imageUrl); ?>" alt="<?php echo e($title); ?>" class="w-full h-48 object-cover" loading="lazy" />
      </figure>

      <div class="card-body">
          <h2 class="card-title">
              <?php echo e($title); ?>

          </h2>

          <p class="text-sm text-gray-500">
              <?php echo e($formattedDate); ?>

          </p>

          <p class="text-sm">
              📍 <?php echo e($location); ?>

          </p>

          <p class="font-bold text-lg mt-2">
              <?php echo e($formattedPrice); ?>

          </p>

      </div>
  </div>
</a>

<?php /**PATH /var/www/html/BK/ticketing_app/resources/views/components/event-card.blade.php ENDPATH**/ ?>