<div class="navbar bg-base-100 shadow-sm">
  <div class="navbar-start">
    <div class="dropdown">
      <div tabindex="0" role="button" class="btn btn-ghost lg:hidden">
        <svg
          xmlns="http://www.w3.org/2000/svg"
          class="h-5 w-5"
          fill="none"
          viewBox="0 0 24 24"
          stroke="currentColor"
        >
          <path
            stroke-linecap="round"
            stroke-linejoin="round"
            stroke-width="2"
            d="M4 6h16M4 12h8m-8 6h16"
          />
        </svg>
      </div>
    </div>
    <img src={{ asset("assets/images/logo_bengkod.svg") }} />
  </div>
  <div class="navbar-center hidden lg:flex">
    @guest <input class="input w-72" placeholder="Cari Event..." /> @endguest
  </div>
  <div class="navbar-end gap-2">
    @guest
    <a href="{{ route('login') }}" class="btn bg-blue-900 text-white">Login</a>
    <a href="{{ route('register') }}" class="btn text-blue-900">Register</a>
    @endguest @auth
    <div class="dropdown dropdown-end">
      <div tabindex="0" role="button" class="btn btn-ghost btn-circle avatar">
        <div class="w-10 rounded-full flex items-center justify-center">
          <svg
            xmlns="http://www.w3.org/2000/svg"
            fill="none"
            viewBox="0 0 24 24"
            stroke-width="1.5"
            stroke="currentColor"
            class="w-6 h-6"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              d="M17.982 18.725A7.488 7.488 0 0012 15.75a7.488 7.488 0 00-5.982 2.975m11.963 0a9 9 0 10-11.963 0m11.963 0A8.966 8.966 0 0112 21a8.966 8.966 0 01-5.982-2.275M15 9.75a3 3 0 11-6 0 3 3 0 016 0z"
            />
          </svg>
        </div>
      </div>
      <ul
        tabindex="0"
        class="menu menu-sm dropdown-content mt-3 z-[1] p-2 shadow bg-base-100 rounded-box w-52"
      >
        <li>
          <a href="{{ route('profile.edit') }}" class="justify-between">
            Profile <span class="badge">{{ Auth::user()->name }}</span>
          </a>
        </li>
        <li>
          <form method="POST" action="{{ route('logout') }}">
            @csrf <button type="submit" class="w-full text-left">Logout</button>
          </form>
        </li>
      </ul>
    </div>
    @endauth
  </div>
</div>
